<?php
// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

coreFunctions::limitEmailsSentPerHour();

/* load file */
if (isset($_REQUEST['u']))
{
    $file = file::loadById($_REQUEST['u']);
    if (!$file)
    {
        // failed lookup of file
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }

    // check current user has permission to edit file
    if ($file->userId != $Auth->id)
    {
        coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
    }
}
else
{
    coreFunctions::redirect(WEB_ROOT . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION);
}
$accountLocked = 0;
if(SITE_CONFIG_SECURITY_ACCOUNT_LOCK == 'yes' && coreFunctions::getUsersAccountLockStatus($Auth->id))
{
    $accountLocked = 1;
}

$isPublic = 1;
if(corefunctions::getOverallPublicStatus($Auth->id, $file->folderId, $file->id) == false)
{
    $isPublic = 0;
}
$isFolderPublic = 1;
if(coreFunctions::getUserFoldersPublicStatus($file->folderId) == false)
{
    $isFolderPublic = 0;
}

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="la la-close"></i></button>
    <h4 class="modal-title">File Information</h4>
</div>
<div class="modal-body">
  <div class="row">
    <div class="col-md-12 detal">
	  <div class="information">
		<div class="group">
	      <h3><?php echo t("hg_name", "Name")?></h3>
		  <p><?php echo validation::safeOutputToScreen($file->originalFilename); ?></p>
	    </div>
	    <div class="group">
	      <h3><?php echo t("hg_size", "Size")?></h3>
	      <p><?php echo coreFunctions::formatSize($file->fileSize); ?></p>
	    </div>
	    <div class="group">
	      <h3><?php echo t("hg_created", "Created")?></h3>
	  	  <p><?php echo coreFunctions::formatDate($file->uploadedDate); ?></p>
	    </div>
	    <div class="group">
	      <h3><?php echo t("hg_last", "Last Accessed")?></h3>
		  <p><?php echo validation::safeOutputToScreen($file->lastAccessed); ?></p>
	    </div>
	    <div class="group">
	      <h3><?php echo t("hg_downloads", "Downloads")?></h3>
		  <p><?php echo validation::safeOutputToScreen($file->visits); ?></p>
	    </div>
	  </div>
	  <?php if ($imageLink = file::getIconPreviewImageUrl((array) $file, false, 160, false, 300, 300)): ?>
      <div class="imageEXE">
        <?php if ($file->statusId == 1): ?><a href="<?php echo validation::safeOutputToScreen(CORE_PAGE_WEB_ROOT.'/account_home_v2_direct_download.php?fileId='.$file->id); ?>" target="_blank"><?php endif; ?>
          <img src="<?php echo $imageLink; ?>" width="<?php echo (substr($imageLink, strlen($imageLink)-4, 4)== '.png')?'160':'300'; ?>" alt="" style="padding-left: <?php echo (substr($imageLink, strlen($imageLink)-4, 4)== '.png')?'':'2'; ?>0px;"/>
        <?php if ($file->statusId == 1): ?></a><?php endif; ?>
      </div>
      <?php endif; ?>
	</div>
  </div>
</div>