<?php
// whether to allow chunked uploaded. Recommend to keep as true unless you're experiencing issues.
define('USE_CHUNKED_UPLOADS', true);
define('CHUNKED_UPLOAD_SIZE', 100000000); // 100MB

// max allowed upload size & max permitted urls
$maxUploadSize    = UserPeer::getMaxUploadFilesize();
$maxPermittedUrls = (int)UserPeer::getMaxRemoteUrls();

// get accepted file types
$acceptedFileTypes = UserPeer::getAcceptedFileTypes();

// whether to allow uploads or not
$showUploads = true;
if(UserPeer::getAllowedToUpload() == false)
{
    $showUploads = false;
}

// load folders
$folderArr = array();
if($Auth->loggedIn())
{
    $folderArr = fileFolder::loadAllActiveForSelect($Auth->id);
}

// uploader javascript
require_once(SITE_TEMPLATES_PATH . '/partial/_uploader_javascript.inc.php');
?>

<div class="preLoadImages hidden">
    <img src="<?php echo SITE_IMAGE_PATH; ?>/delete_small.png" height="1" width="1"/>
    <img src="<?php echo SITE_IMAGE_PATH; ?>/add_small.gif" height="1" width="1"/>
    <img src="<?php echo SITE_IMAGE_PATH; ?>/red_error_small.png" height="1" width="1"/>
    <img src="<?php echo SITE_IMAGE_PATH; ?>/green_tick_small.png" height="1" width="1"/>
    <img src="<?php echo SITE_IMAGE_PATH; ?>/blue_right_arrow.png" height="1" width="1"/>
    <img src="<?php echo SITE_IMAGE_PATH; ?>/processing_small.gif" height="1" width="1"/>
</div>

<div>
    <ul class="nav nav-tabs bordered">
        <li class="active"><a href="#fileUpload" data-toggle="tab"><i class="la la-laptop zmdi-hc-fw"></i> <span><?php echo UCWords(t('file_upload_sv', 'local upload')); ?></span></a></li>
        <?php if(UserPeer::userTypeCanUseRemoteUrlUpload()): ?>
		<li><a href="#urlUpload" data-toggle="tab"><i class="la la-link zmdi-hc-fw"></i> <span><?php echo UCWords(t('remote_url_upload_4', 'url upload')); ?></span></a></li>
        <?php endif; ?>
		<?php
        // append any plugin includes
        pluginHelper::includeAppends('index_tab.inc.php');
        ?>
    </ul>

    <!-- FILE UPLOAD -->
    <div class="tab-content">
        <div id="fileUpload" class="tab-pane active">
            <div class="fileUploadMain">
                <div <?php if($showUploads == false) { if ((UserPeer::getAllowedToUpload(0) == false) && (UserPeer::getAllowedToUpload(1) == true)) echo 'onClick="window.location=\'register.' . SITE_CONFIG_PAGE_EXTENSION . '\';"'; else echo 'onClick="alert(\''.t('index_uploading_disabled', 'Error: Uploading has been disabled.').'\'); return false;";'; } ?>>
                    
                    <!-- uploader -->
                    <div id="uploaderContainer" class="uploader-container">
                        <div id="uploader">
                            <form action="<?php //echo crossSiteAction::appendUrl(file::getUploadUrl().'/core/ajax/file_upload_handler.ajax.php?r='.htmlspecialchars(_CONFIG_SITE_HOST_URL).'&p='.htmlspecialchars(_CONFIG_SITE_PROTOCOL)); ?>" method="POST" enctype="multipart/form-data">
                                <div class="fileupload-buttonbar hiddenAlt">
                                    <label class="fileinput-button">
                                        <span><?php echo t('add_files', 'Add files...'); ?></span>
                                        <?php
                                        if ($showUploads == true)
                                        {
											if(coreFunctions::ifBrowserAllowsMultipleUploads() == true)
											{
												echo '<input id="add_files_btn" type="file" name="files">';
											}
											else
											{
												echo '<input id="add_files_btn" type="file" name="files[]" multiple>';
											}
                                        }
                                        ?>
                                    </label>
                                    <button id="start_upload_btn" type="submit" class="start"><?php echo t('start_upload', 'Start upload'); ?></button>
                                    <button id="cancel_upload_btn" type="reset" class="cancel"><?php echo t('cancel_upload', 'Cancel upload'); ?></button>
                                </div>
                                <div class="fileupload-content">
                                    <label class="uploa" for="add_files_btn">
                                        <div id="initialUploadSection" class="initialUploadSection"<?php if (!Stats::currentBrowserIsIE()): ?> onClick="$('#add_files_btn').click();
                                                    return false;"<?php endif; ?>>
                                            <div class="initialUploadText">
                                                <div class="uploadElement">
                                                    <div class="internal">
                                                        <svg width="48" height="69" viewBox="0 0 48 69" class="hgUpload">
                                                           <path d="M.5 1.5h5zM10.5 1.5h5zM20.5 1.5h5zM30.504 1.5h5zM45.5 11.5v5zM45.5 21.5v5zM45.5 31.5v5zM45.5 41.502v5zM45.5 51.502v5zM45.5 61.5v5zM45.5 66.502h-4.998zM35.503 66.502h-5zM25.5 66.502h-5zM15.5 66.502h-5zM5.5 66.502h-5zM.5 66.502v-5zM.5 56.502v-5zM.5 46.503V41.5zM.5 36.5v-5zM.5 26.5v-5zM.5 16.5v-5zM.5 6.5V1.498zM44.807 11H36V2.195z"></path>
                                                        </svg>
                                                        <div class="clear"><!-- --></div>
                                                        <p> Drag & drop files here to upload, or <span>browse</span></p>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="clear"><!-- --></div>
                                        </div>
                                    </label>
                                    <div id="fileListingWrapper" class="fileListingWrapper hidden">
										<div class="fileSection">
										    <div id="files" class="files"></div>
                                        </div>

                                       
			
                                        <div id="processingQueueSection" class="fileSectionFooterText hidden">
                                            
                                           
                                                <div id="cont" class="noFile" data-pct="0">
<svg id="svg" width="300" height="300" viewPort="0 0 150 150" version="1.1" xmlns="http://www.w3.org/2000/svg">
  <circle r="125" cx="150" cy="150" fill="transparent" stroke-dasharray="785.48" stroke-dashoffset="0"></circle>
  <circle id="bar" r="125" cx="150" cy="150" fill="transparent" stroke-dasharray="785.48" stroke-dashoffset="0"></circle>
</svg>
</div>
                                        </div>

                                        <div id="completedSection" class="fileSectionFooterText row hidden">
                                            
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
						
                                                
                                                
                                                    
                                                    
                                                
                                           
                        <script id="template-upload" type="text/x-jquery-tmpl">
							{% for (var i=0, file; file=o.files[i]; i++) { %}
							<ul class="hg-upl-files template-upload{% if (file.error) { %} errorText{% } %}"><li id="fileUploadRow{%=i%}">
							<span class="hg-icon la la-file-o hg-color-danger"></span>
							<div class="hg-body">
							<div class="hg-header">
                                <span class="hg-filename">{%=file.name%}</span>
                            </div>
							<div class="hg-description">
                                Size: &nbsp;&nbsp;{%=o.formatFileSize(file.size)%}
                            {% if (!file.error) { %}
                            <div class="start hidden"><button>start</button></div>
                            {% } %}
                            <div class="cancel hidden"><button>cancel</button></div>
							</div>
							{% if (file.error) { %}
                            <div colspan="2" class="error"><?php echo t('index_error', 'Error'); ?>:
                           {%=file.error%}
                            </td>
                            {% } else { %}
                            <td colspan="2" class="preview"><span class="fade"></span></td>
                            {% } %}
                            
                            </div>
							<div class="hg-remove cancel">
                                <a  href="#" onClick="return false;"><i class="hg-icon la la-trash"></i></a>
                            </div>
                            </div>
                            </li></ul>
                            {% } %}
                        </script>

                        <script id="template-download" type="text/x-jquery-tmpl"><!-- --></script>

                    </div>
                    <!-- end uploader -->

                </div>

                <div class="clear"><!-- --></div>
            </div>
        </div>

        <!-- URL UPLOAD -->
        <div class="tab-pane" id="urlUpload"  <?php if($showUploads == false) { if ((UserPeer::getAllowedToUpload(0) == false) && (UserPeer::getAllowedToUpload(1) == true)) echo 'onClick="window.location=\'register.' . SITE_CONFIG_PAGE_EXTENSION . '\';"'; else echo 'onClick="alert(\''.t('index_uploading_disabled', 'Error: Uploading has been disabled.').'\'); return false;";'; } ?>>
            <div class="urlUploadMain">
                <div>
                    <!-- url uploader -->
                    <div>
						<?php if((SITE_CONFIG_REMOTE_URL_DOWNLOAD_IN_BACKGROUND == 'yes') && ($Auth->loggedIn())): ?>
						<div id="urlBackgroundDownloadExistingWrapper"><!-- --></div>
						<?php endif; ?>
                        <div id="urlFileUploader">
                            <div class="urlFileUploaderWrapper">
                            <form action="<?php //echo crossSiteAction::appendUrl(file::getUploadUrl()."/core/ajax/url_upload_handler.php"); ?>" method="POST" enctype="multipart/form-data">
                                <div class="initialUploadText">
                                    <p>
                                        <?php echo t('file_upload_remote_url_intro', 'Download files directly from other sites into your account. Note: If the files are on another file download site or password protected, this may not work.'); ?><br/><br/>
                                    </p>
                                    <div class="inputElement">
                                        <textarea name="urlList" id="urlList" class="urlList form-control" placeholder="http://example-site.com/file.zip"></textarea>
                                        <div class="clear"><!-- --></div>
                                    </div>
                                </div>
                               
                                <div class="clear"><!-- --></div>
                            </form>
                                </div>
                        </div>

                        <div id="urlFileListingWrapper" class="urlFileListingWrapper hidden">
                            <div class="fileSection">
                                <table id="urls" class="files table table-striped">
                                    <tbody>
                                    </tbody>
                                </table>
                                <div class="clear"><!-- --></div>
                                <div class="upload-button processing-button">
                                    <button onClick="$('#start_upload_btn').click(); return false;" class="btn btn-default disabled btn-lg" type="button"><?php echo t("set_upload_processing", "Processing..."); ?> <i class="entypo-arrows-ccw"></i></button>
                                </div>
                            </div>
                            <div class="clear"><!-- --></div>

                            <div class="fileSectionFooterText row hidden">
                                <div class="col-md-3">
                                    <div class="copyAllLinkWrapper">
                                        <a class="copyAllLink" data-clipboard-action="copy" data-clipboard-target="#clipboard-placeholder" href="#">[<?php echo t('copy_all_links', 'copy all links'); ?>]</a>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="baseText">
                                        <?php echo t('file_transfers_completed', 'File transfers completed.'); ?> <?php echo t('index_upload_more_files', '<a href="[[[WEB_ROOT]]]">Click here</a> to upload more files.', array('WEB_ROOT'=>defined('FROM_ACCOUNT_HOME')?(WEB_ROOT.'/account_home.'.SITE_CONFIG_PAGE_EXTENSION.'?upload=1'):(WEB_ROOT.'/index.'.SITE_CONFIG_PAGE_EXTENSION.'?upload=1'))); ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="upload-button">
                                        <button data-dismiss="modal" class="btn btn-info" type="button"><?php echo t("set_close", "Close"); ?> <i class="entypo-check"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- end url uploader -->

                </div>

                <div class="clear"><!-- --></div>
            </div>
        </div>

        <?php
        // append any plugin includes
        pluginHelper::includeAppends('index_tab_content.inc.php');
        ?>
    </div>
	

</div>

<div id="additionalOptionsWrapper" class="additional-options-wrapper" style="display: none;">

	<!-- added to disable Chome autocomplete -->
	<input style="display:none">
	<input type="password" style="display:none">

    <div class="row">
        <div class="col-md-4">
            <div class="row">
                <div class="col-xs-4">
                    <div class="icon">
                        <img src="<?php echo SITE_THEME_PATH; ?>/hg/img/mail.svg" height="80">
                    </div>
                </div>
                <div class="col-xs-8">
                    <div class="form-group">
                        <label class="control-label" for="send_via_email"><?php echo UCWords(t('send_via_email', 'send via email:')); ?></label>
                        <input id="send_via_email" name="send_via_email" type="text" class="form-control" placeholder="email address"/>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="row">
                <div class="col-xs-4">
                    <div class="icon">
                        <img src="<?php echo SITE_THEME_PATH; ?>/hg/img/folder.svg" height="80">
                    </div>
                </div>
                <div class="col-xs-8">
                    <div class="form-group">
                        <label class="control-label" for="upload_folder_id"><?php echo UCWords(t('store_in_folder', 'store in folder:')); ?></label>
                        <select id="upload_folder_id" name="upload_folder_id" class="form-control" <?php echo !$Auth->loggedIn() ? 'DISABLED="DISABLED"' : ''; ?>>
                            <option value=""><?php echo !$Auth->loggedIn() ? t("index_login_to_enable", "- login to enable -") : t("index_default", "- default -"); ?></option>
                            <?php
                            if(COUNT($folderArr))
                            {
                                foreach($folderArr AS $id => $folderLabel)
                                {
                                    echo '<option value="'.(int)$id.'"';
                                    if($fid == (int)$id)
                                    {
                                        echo ' SELECTED';
                                    }
                                    echo '>'.validation::safeOutputToScreen($folderLabel).'</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="row">
                <div class="col-xs-4">
                    <div class="icon">
                        <img src="<?php echo SITE_THEME_PATH; ?>/hg/img/lock.svg" height="80">
                    </div>
                </div>
                <div class="col-xs-8">
                    <div class="form-group">
                        <label class="control-label" for="set_password"><?php echo UCWords(t('set_password', 'set password:')); ?></label>
                        <input id="set_password" name="set_password" type="password" type="text" class="form-control" placeholder="file's password"/>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="modal-footer">
	<div class="row">
	  <div class="col-md-6 text-left">
		<button type="button" onClick="$('#start_upload_btn').click(); return false;"  id="uploadButton" class="btn btn-primary btn-upload disabled"><i class="la la-upload"></i> Upload</button>
		<a class="btn btn-default btn-add hidden" id="addFiles" href="#"<?php if (!Stats::currentBrowserIsIE()): ?> onClick="$('#add_files_btn').click(); return false;"<?php endif; ?>>
            <label for="add_files_btn"><i class="la la-plus"></i> Add File's</label>
        </a>
		<button type="button" id="transferFilesButton" onClick="urlUploadFiles(); return false;" class="btn btn-primary btn-upload hidden"><i class="zmdi zmdi-swap"></i> Transfer</button>
	  </div>
	  <div class="col-md-6 text-right">
		<a type="button" id="options" class="btn btn-info btn-options showAdditionalOptionsLink" ><i class="la la-gear"></i> Options</a>
	    <a type="button" id="saveoptions" onClick="saveAdditionalOptions(); return false;" class="btn btn-info btn-options hidden" ><i class="la la-check"></i> Save Options</a>
		
	  </div>
	</div>
</div>
